/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.ICompositeWidget;
import appeng.client.gui.MathExpressionParser;
import appeng.client.gui.NumberEntryType;
import appeng.client.gui.Rects;
import appeng.client.gui.style.PaletteColor;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.style.WidgetStyle;
import appeng.client.gui.widgets.ConfirmableTextField;
import appeng.client.gui.widgets.ValidationIcon;
import appeng.core.localization.GuiText;
import com.google.common.primitives.Longs;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_768;

public class NumberEntryWidget
implements ICompositeWidget {
    private static final long[] STEPS = new long[]{1L, 10L, 100L, 1000L};
    private static final class_2561 PLUS = class_2561.method_43470((String)"+");
    private static final class_2561 MINUS = class_2561.method_43470((String)"-");
    private static final int UNIT_PADDING = 3;
    private final int errorTextColor;
    private final int normalTextColor;
    private final ConfirmableTextField textField;
    private final DecimalFormat decimalFormat;
    private NumberEntryType type;
    private List<class_4185> buttons;
    private long minValue;
    private long maxValue = Long.MAX_VALUE;
    private ValidationIcon validationIcon;
    private Runnable onChange;
    private Runnable onConfirm;
    private boolean hideValidationIcon;
    private class_768 bounds = new class_768(0, 0, 0, 0);
    private class_768 textFieldBounds = Rects.ZERO;
    private Point currentScreenOrigin = Point.ZERO;

    public NumberEntryWidget(ScreenStyle style, NumberEntryType type) {
        this.errorTextColor = style.getColor(PaletteColor.TEXTFIELD_ERROR).toARGB();
        this.normalTextColor = style.getColor(PaletteColor.TEXTFIELD_TEXT).toARGB();
        this.type = Objects.requireNonNull(type, "type");
        this.decimalFormat = new DecimalFormat("#.######", new DecimalFormatSymbols());
        this.decimalFormat.setParseBigDecimal(true);
        this.decimalFormat.setNegativePrefix("-");
        class_327 font = class_310.method_1551().field_1772;
        Objects.requireNonNull(font);
        this.textField = new ConfirmableTextField(style, font, 0, 0, 0, 9);
        this.textField.method_1858(false);
        this.textField.method_1880(16);
        this.textField.method_1868(this.normalTextColor);
        this.textField.method_1862(true);
        this.textField.method_1863(text -> {
            this.validate();
            if (this.onChange != null) {
                this.onChange.run();
            }
        });
        this.textField.setOnConfirm(() -> {
            if (this.onConfirm != null && this.getLongValue().isPresent()) {
                this.onConfirm.run();
            }
        });
        this.validate();
    }

    public void setOnConfirm(Runnable callback) {
        this.onConfirm = callback;
    }

    public void setOnChange(Runnable callback) {
        this.onChange = callback;
    }

    public void setActive(boolean active) {
        this.textField.method_1888(active);
        this.buttons.forEach(b -> {
            b.field_22763 = active;
        });
    }

    public void setTextFieldBounds(class_768 bounds) {
        this.textFieldBounds = bounds;
        this.textField.move(this.currentScreenOrigin.move(bounds.method_3321(), bounds.method_3322()));
        int unitWidth = 0;
        if (this.type.unit() != null) {
            unitWidth = class_310.method_1551().field_1772.method_1727(this.type.unit()) + 3;
        }
        this.textField.resize(bounds.method_3319() - unitWidth, bounds.method_3320());
    }

    public void setTextFieldStyle(WidgetStyle style) {
        int left = 0;
        if (style.getLeft() != null) {
            left = style.getLeft();
        }
        int top = 0;
        if (style.getTop() != null) {
            top = style.getTop();
        }
        this.setTextFieldBounds(new class_768(left, top, style.getWidth(), style.getHeight()));
    }

    public void setMinValue(long minValue) {
        this.minValue = minValue;
        this.validate();
    }

    public void setMaxValue(long maxValue) {
        this.maxValue = maxValue;
        this.validate();
    }

    @Override
    public void setPosition(Point position) {
        this.bounds = new class_768(position.getX(), position.getY(), this.bounds.method_3319(), this.bounds.method_3320());
    }

    @Override
    public void setSize(int width, int height) {
        this.bounds = new class_768(this.bounds.method_3321(), this.bounds.method_3322(), width, height);
    }

    @Override
    public class_768 getBounds() {
        return this.bounds;
    }

    @Override
    public void populateScreen(Consumer<class_339> addWidget, class_768 bounds, AEBaseScreen<?> screen) {
        int left = bounds.method_3321() + this.bounds.method_3321();
        int top = bounds.method_3322() + this.bounds.method_3322();
        ArrayList<class_4185> buttons = new ArrayList<class_4185>(9);
        buttons.add(class_4185.method_46430((class_2561)this.makeLabel(PLUS, STEPS[0]), btn -> this.addQty(STEPS[0])).method_46434(left, top, 22, 20).method_46431());
        buttons.add(class_4185.method_46430((class_2561)this.makeLabel(PLUS, STEPS[1]), btn -> this.addQty(STEPS[1])).method_46434(left + 28, top, 28, 20).method_46431());
        buttons.add(class_4185.method_46430((class_2561)this.makeLabel(PLUS, STEPS[2]), btn -> this.addQty(STEPS[2])).method_46434(left + 62, top, 32, 20).method_46431());
        buttons.add(class_4185.method_46430((class_2561)this.makeLabel(PLUS, STEPS[3]), btn -> this.addQty(STEPS[3])).method_46434(left + 100, top, 38, 20).method_46431());
        buttons.forEach(addWidget);
        this.currentScreenOrigin = Point.fromTopLeft(bounds);
        this.setTextFieldBounds(this.textFieldBounds);
        screen.method_48265((class_364)this.textField);
        addWidget.accept((class_339)this.textField);
        buttons.add(class_4185.method_46430((class_2561)this.makeLabel(MINUS, STEPS[0]), btn -> this.addQty(-STEPS[0])).method_46434(left, top + 42, 22, 20).method_46431());
        buttons.add(class_4185.method_46430((class_2561)this.makeLabel(MINUS, STEPS[1]), btn -> this.addQty(-STEPS[1])).method_46434(left + 28, top + 42, 28, 20).method_46431());
        buttons.add(class_4185.method_46430((class_2561)this.makeLabel(MINUS, STEPS[2]), btn -> this.addQty(-STEPS[2])).method_46434(left + 62, top + 42, 32, 20).method_46431());
        buttons.add(class_4185.method_46430((class_2561)this.makeLabel(MINUS, STEPS[3]), btn -> this.addQty(-STEPS[3])).method_46434(left + 100, top + 42, 38, 20).method_46431());
        if (!this.hideValidationIcon) {
            this.validationIcon = new ValidationIcon();
            this.validationIcon.method_46421(left + 104);
            this.validationIcon.method_46419(top + 27);
            buttons.add(this.validationIcon);
        }
        buttons.subList(4, buttons.size()).forEach(addWidget);
        this.buttons = buttons;
        this.validate();
    }

    public boolean startsWithEquals() {
        return this.textField.method_1882().startsWith("=");
    }

    public OptionalInt getIntValue() {
        OptionalLong value = this.getLongValue();
        if (value.isPresent()) {
            long longValue = value.getAsLong();
            if (longValue > Integer.MAX_VALUE) {
                return OptionalInt.empty();
            }
            return OptionalInt.of((int)longValue);
        }
        return OptionalInt.empty();
    }

    public OptionalLong getLongValue() {
        Optional<BigDecimal> internalValue = this.getValueInternal();
        if (internalValue.isEmpty()) {
            return OptionalLong.empty();
        }
        if (this.type.amountPerUnit() == 1 && internalValue.get().scale() > 0) {
            return OptionalLong.empty();
        }
        long externalValue = this.convertToExternalValue(internalValue.get());
        if (externalValue < this.minValue) {
            return OptionalLong.empty();
        }
        if (externalValue > this.maxValue) {
            return OptionalLong.empty();
        }
        return OptionalLong.of(externalValue);
    }

    public void setLongValue(long value) {
        BigDecimal internalValue = this.convertToInternalValue(Longs.constrainToRange((long)value, (long)this.minValue, (long)this.maxValue));
        this.textField.method_1852(this.decimalFormat.format(internalValue));
        this.textField.method_1872();
        this.textField.method_1884(0);
        this.validate();
    }

    private void addQty(long delta) {
        BigDecimal currentValue = this.getValueInternal().orElse(BigDecimal.ZERO);
        BigDecimal newValue = currentValue.add(BigDecimal.valueOf(delta));
        BigDecimal minimum = this.convertToInternalValue(this.minValue).setScale(0, RoundingMode.CEILING);
        BigDecimal maximum = this.convertToInternalValue(this.maxValue).setScale(0, RoundingMode.FLOOR);
        if (newValue.compareTo(minimum) < 0) {
            newValue = minimum;
        } else if (newValue.compareTo(maximum) > 0) {
            newValue = maximum;
        } else if (currentValue.compareTo(BigDecimal.ONE) == 0 && delta > 0L && delta % 10L == 0L) {
            newValue = newValue.subtract(BigDecimal.ONE);
        }
        this.setValueInternal(newValue);
    }

    private Optional<BigDecimal> getValueInternal() {
        String textValue = this.textField.method_1882();
        if (textValue.startsWith("=")) {
            textValue = textValue.substring(1);
        }
        return MathExpressionParser.parse(textValue, this.decimalFormat);
    }

    private boolean isNumber() {
        ParsePosition position = new ParsePosition(0);
        String textValue = this.textField.method_1882().trim();
        this.decimalFormat.parse(textValue, position);
        return position.getErrorIndex() == -1 && position.getIndex() == textValue.length();
    }

    private void setValueInternal(BigDecimal value) {
        this.textField.method_1852(this.decimalFormat.format(value));
    }

    private void validate() {
        ArrayList<class_5250> validationErrors = new ArrayList<class_5250>();
        ArrayList<class_2561> infoMessages = new ArrayList<class_2561>();
        Optional<BigDecimal> possibleValue = this.getValueInternal();
        if (possibleValue.isPresent()) {
            if (this.type.amountPerUnit() == 1 && possibleValue.get().scale() > 0) {
                validationErrors.add(GuiText.NumberNonInteger.text());
            } else {
                long value = this.convertToExternalValue(possibleValue.get());
                if (value < this.minValue) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(this.minValue));
                    validationErrors.add(GuiText.NumberLessThanMinValue.text(formatted));
                } else if (value > this.maxValue) {
                    String formatted = this.decimalFormat.format(this.convertToInternalValue(this.maxValue));
                    validationErrors.add(GuiText.NumberGreaterThanMaxValue.text(formatted));
                } else if (!this.isNumber()) {
                    infoMessages.add((class_2561)class_2561.method_43470((String)("= " + this.decimalFormat.format(possibleValue.get()))));
                }
            }
        } else {
            validationErrors.add(GuiText.InvalidNumber.text());
        }
        boolean valid = validationErrors.isEmpty();
        ArrayList<class_2561> tooltip = valid ? infoMessages : validationErrors;
        this.textField.method_1868(valid ? this.normalTextColor : this.errorTextColor);
        this.textField.setTooltipMessage(tooltip);
        if (this.validationIcon != null) {
            this.validationIcon.setValid(valid);
            this.validationIcon.setTooltip(tooltip);
        }
    }

    private class_2561 makeLabel(class_2561 prefix, long amount) {
        return prefix.method_27662().method_27693(this.decimalFormat.format(amount));
    }

    public void setHideValidationIcon(boolean hideValidationIcon) {
        this.hideValidationIcon = hideValidationIcon;
    }

    public NumberEntryType getType() {
        return this.type;
    }

    public void setType(NumberEntryType type) {
        if (this.type == type) {
            return;
        }
        this.type = type;
        this.setTextFieldBounds(this.textFieldBounds);
        if (this.onChange != null) {
            this.onChange.run();
        }
        this.validate();
    }

    private long convertToExternalValue(BigDecimal internalValue) {
        BigDecimal multiplicand = BigDecimal.valueOf(this.type.amountPerUnit());
        BigDecimal value = internalValue.multiply(multiplicand, MathContext.DECIMAL128);
        value = value.setScale(0, RoundingMode.UP);
        return value.longValue();
    }

    private BigDecimal convertToInternalValue(long externalValue) {
        BigDecimal divisor = BigDecimal.valueOf(this.type.amountPerUnit());
        return BigDecimal.valueOf(externalValue).divide(divisor, MathContext.DECIMAL128);
    }

    @Override
    public void drawBackgroundLayer(class_332 guiGraphics, class_768 bounds, Point mouse) {
        if (this.type.unit() != null) {
            class_327 font = class_310.method_1551().field_1772;
            int x = bounds.method_3321() + this.textFieldBounds.method_3321() + this.textFieldBounds.method_3319() - font.method_1727(this.type.unit());
            float f = bounds.method_3322() + this.textFieldBounds.method_3322();
            int n = this.textFieldBounds.method_3320();
            Objects.requireNonNull(font);
            int y = (int)(f + (float)(n - 9) / 2.0f + 1.0f);
            guiGraphics.method_51433(font, this.type.unit(), x, y, class_124.field_1063.method_532().intValue(), false);
        }
    }

    @Override
    public boolean onMouseWheel(Point mousePos, double delta) {
        if (this.textFieldBounds.method_3318(mousePos.getX(), mousePos.getY()) && this.getValueInternal().isPresent()) {
            if (delta < 0.0) {
                this.addQty(-1L);
            } else if (delta > 0.0) {
                this.addQty(1L);
            }
            return true;
        }
        return false;
    }
}

